/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.cap;

import com.nyfaria.numismaticoverhaul.cap.CurrencyHolderAttacher;
import com.nyfaria.numismaticoverhaul.currency.CurrencyConverter;
import com.nyfaria.numismaticoverhaul.item.CoinItem;
import com.nyfaria.numismaticoverhaul.network.NetworkHandler;
import dev._100media.capabilitysyncer.core.ISyncableCapability;
import dev._100media.capabilitysyncer.core.PlayerCapability;
import dev._100media.capabilitysyncer.network.EntityCapabilityStatusPacket;
import dev._100media.capabilitysyncer.network.SimpleEntityCapabilityStatusPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.simple.SimpleChannel;

public class CurrencyHolder
extends PlayerCapability {
    private long value;
    private final List<Long> transactions = new ArrayList<Long>();

    protected CurrencyHolder(Player player) {
        super(player);
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
        this.updateTracking();
    }

    public void silentModify(long value) {
        this.setValue(this.value + value);
    }

    public Long popTransaction() {
        return this.transactions.remove(this.transactions.size() - 1);
    }

    public void pushTransaction(long value) {
        this.transactions.add(value);
    }

    public CompoundTag serializeNBT(boolean savingToDisk) {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("value", this.value);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt, boolean readingFromDisk) {
        this.value = nbt.m_128454_("value");
    }

    public EntityCapabilityStatusPacket createUpdatePacket() {
        return new SimpleEntityCapabilityStatusPacket(this.entity.m_19879_(), CurrencyHolderAttacher.EXAMPLE_RL, (ISyncableCapability)this);
    }

    public void modify(long value) {
        this.setValue(this.value + value);
        long tempValue = value < 0L ? -value : value;
        List<ItemStack> transactionStacks = CurrencyConverter.getAsItemStackList(tempValue);
        if (transactionStacks.isEmpty()) {
            return;
        }
        MutableComponent message = value < 0L ? Component.m_237113_((String)"\u00a7c- ") : Component.m_237113_((String)"\u00a7a+ ");
        message.m_7220_((Component)Component.m_237113_((String)"\u00a77["));
        for (ItemStack stack : transactionStacks) {
            message.m_7220_((Component)Component.m_237113_((String)("\u00a7b" + stack.m_41613_() + " ")));
            message.m_7220_((Component)Component.m_237115_((String)("currency.numismaticoverhaul." + ((CoinItem)stack.m_41720_()).currency.name().toLowerCase())));
            if (transactionStacks.indexOf(stack) == transactionStacks.size() - 1) continue;
            message.m_7220_((Component)Component.m_237113_((String)", "));
        }
        message.m_7220_((Component)Component.m_237113_((String)"\u00a77]"));
        this.player.m_5661_((Component)message, true);
    }

    public SimpleChannel getNetworkChannel() {
        return NetworkHandler.INSTANCE;
    }

    public void commitTransactions() {
        this.modify(this.transactions.stream().mapToLong(Long::longValue).sum());
        this.transactions.clear();
    }
}

